#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>

#include "myriexpress.h"
#include "test_common.h"

void fill_data(char *buff, int len)
{
  int i;
  for (i = 0; i < len; i++)
    buff[i] = 'a' + i % 26;
}

int check_data(char *buff, int len)
{
  int i, err = 0;
  for (i = 0; i < len; i++)
    if (buff[i] != 'a' + i % 26) {
      printf ("recv_buff[%d] should recv: %c (%d), but recv: %c (%d)\n", 
	      i, 'a' + i % 26, 'a' + i % 26, 
	      buff[i], buff[i]);
      fflush(stdout);
      err ++;
    }
  if (err) {
    printf ("Find %d errors.\n", err);
    return 0;
  }
  return 1;
}   

void fill_data_int(char *buff, int len)
{
  int i;
  int *buff_as_int = (int *) buff;
  for (i = 0; i < len; i+=4)
    buff_as_int[i/4] = i;
}

int check_data_int(char *buff, int len, int offset)
{
  int i, err = 0;
  int first_error = -1;
  int last_error = -1;
  int *buff_as_int = (int *) buff;
  for (i = 0; i < len; i+=4)
    if (buff_as_int[i/4] != i) {
      printf ("recv_buff[%d] (0x%p) should recv: %d, but recv: %d\n", 
	      i, &buff_as_int[i/4], i, buff_as_int[i/4]);
      if (first_error == - 1)
	first_error = i;
      last_error = i;
      //      fflush(stdout);
      err ++;
      i += 4092;
    }
  if (err) {
    printf ("Found %d bad pages, first at %d, last at %d\n", err, first_error, last_error);
    return 0;
  }
  return 1;
}   

void get_rank(int argc, char **argv, uint32_t *pmy_rank)
{
  if (argc != 2) {
    printf("my_rank missng.\n");
    FAIL();
  }
  *pmy_rank = atoi(argv[1]);
}

void get_filename(char **pfilename)
{
  *pfilename = getenv("THE_HOSTS");
 if (*pfilename == NULL) {
   printf("THE_HOSTS not set.\n");
   FAIL();
 }
}

void get_hosts(char *filename, struct host_entry **phosts, int *pcount)
{
  *phosts = parse_hosts(filename, pcount);
  if (*phosts == NULL) {
    printf("unable to parse hosts file.\n");
    FAIL();
  }
}

void get_ep(struct host_entry *hosts, uint32_t my_rank, mx_endpoint_t *pep)
{
  mx_return_t ret;
  uint64_t nic_id;
  uint32_t board;
  ret = mx_init();
  if (ret != MX_SUCCESS) {
    printf("mx_init failed.\n");
    FAIL();
  }
  mx_set_error_handler(MX_ERRORS_RETURN);
  ret = mx_hostname_to_nic_id(hosts[my_rank].mx_name, &nic_id);
  if (ret != MX_SUCCESS) {
    printf("Couldn't look up my hostname.\n");
    FAIL();
  }
  ret = mx_nic_id_to_board_number(nic_id, &board);
  if (ret != MX_SUCCESS) {
    printf("Couldn't get board number.\n");
    FAIL();
  }
  ret = mx_open_endpoint(board, hosts[my_rank].eid, THE_KEY, NULL, 0, pep);
  if (ret != MX_SUCCESS) {
    printf("mx_open_endpoint_failed.\n");
    FAIL();
  }
}

void connect_hosts(struct host_entry *hosts, int count, int my_rank,
		   mx_endpoint_t ep)
{
  if (connect_to_everyone(hosts, count, my_rank, ep) != 0) {
    printf("failed to connect to everybody else.\n");
    FAIL();
  }
}

void release_ep(mx_endpoint_t ep)
{
  mx_return_t ret;
  ret = mx_close_endpoint(ep);
  if (ret != MX_SUCCESS) {
    printf("mx_close_endpoint failed.\n");
     FAIL();
  }
  ret = mx_finalize();
  if (ret != MX_SUCCESS) {
    printf("mx_finalize failed.\n");
    FAIL();
  }
}


/*{{{ whitespace_only
 * Checks to see if the line only contains whitespace.
 * 0 - no, line contains characters other than whitespace
 * 1 - yes, line contains only whitespace
 */
int whitespace_only(char *line)
{
  size_t len;
  size_t i;

  len = strlen(line);
  for (i = 0; i < len; ++i) {
    switch (line[i]) {
    case ' ':
    case '\t':
    case '\n':
      continue;
    default:
      return 0;
    }
  }
  return 1;
}
/*}}}*/

/*{{{ parse_hosts
 * Reads the hosts file and returns an array of host entries. Also sets
 * *count to the number of entries. Memory returned musted be
 * deallocated via free.
 */
struct host_entry * parse_hosts(char *filename, int *count)
{
  FILE *fp;
  char line[256];
  struct host_entry *entry = NULL;

  if ((fp = fopen(filename, "r")) == NULL) {
    return NULL;
  }

  /* Count the number of entries. */
  *count = 0;
  while (fgets(line, 256, fp) != NULL) {
    if (line[0] == '#') { /* comment */
      continue;
    }
    if (whitespace_only(line)) { /* empty line */
      continue;
    }
    *count += 1;
  }

  if (*count == 0) {
    return NULL;
  }
  entry = malloc(*count * sizeof(*entry));
  if (entry == NULL) {
    fclose(fp);
    return NULL;
  }

  fseek(fp, 0, SEEK_SET);
  *count = 0;
  while (fgets(line, 256, fp) != NULL) {
    if (line[0] == '#') { /* comment */
      continue;
    }
    if (whitespace_only(line)) { /* empty line */
      continue;
    }
    sscanf(line, "%s %s %d", entry[*count].ip_name,
	   entry[*count].mx_name, &entry[*count].eid);
    *count += 1;
  }
  fclose(fp);
  return entry;
}
/*}}}*/

int connect_to_everyone(struct host_entry *hosts, int count,
			int my_rank, mx_endpoint_t ep)
{
  int i;
  mx_return_t ret;
  uint64_t nic_id;

  for (i = 0; i < count; ++i) {
#if 0
    if (i == my_rank) {
      mx_get_endpoint_addr(ep, &hosts[i].addr);
      continue;
    }
#endif
    ret = mx_hostname_to_nic_id(hosts[i].mx_name, &nic_id);
    if (ret != MX_SUCCESS) {
      printf("mx_hostname_to_nic_id failed.\n");
      return 1;
    }
    ret = mx_connect(ep, nic_id, hosts[i].eid, THE_KEY, MX_INFINITE,
		     &hosts[i].addr);
    while (ret != MX_SUCCESS) {
      printf("Couldn't connect with %d, sleeping.\n", i);
      sleep(1);
      ret = mx_connect(ep, nic_id, hosts[i].eid, THE_KEY, MX_INFINITE,
		       &hosts[i].addr);
    }
    printf("Connected with %d.\n", i);
  }

  sleep(5);

  return 0;
}

int run_test(struct host_entry *hosts, int count, int my_rank)
{
  mx_return_t ret;
  uint64_t nic_id;
  uint32_t board;
  mx_endpoint_t ep;

  ret = mx_init();
  if (ret != MX_SUCCESS) {
    printf("mx_init failed.\n");
    return 1;
  }

  mx_set_error_handler(MX_ERRORS_RETURN);

  ret = mx_hostname_to_nic_id(hosts[my_rank].mx_name, &nic_id);
  if (ret != MX_SUCCESS) {
    printf("Couldn't look up my hostname.\n");
    return 1;
  }
  ret = mx_nic_id_to_board_number(nic_id, &board);
  if (ret != MX_SUCCESS) {
    printf("Couldn't get board number.\n");
    return 1;
  }

  ret = mx_open_endpoint(board, hosts[my_rank].eid, THE_KEY, NULL, 0, &ep);
  if (ret != MX_SUCCESS) {
    printf("mx_open_endpoint failed.\n");
    return 1;
  }

  printf("opened endpoint\n");

  connect_to_everyone(hosts, count, my_rank, ep);

  ret = mx_close_endpoint(ep);
  if (ret != MX_SUCCESS) {
    printf("mx_close_endpoint failed.\n");
    return 1;
  }

  printf("closed endpoint\n");

  ret = mx_finalize();
  if (ret != MX_SUCCESS) {
    printf("mx_finalize failed.\n");
    return 1;
  }

  return 0;
}

#if 0
int main(int argc, char **argv)
{
  struct host_entry *hosts;
  int count;
  char *filename;
  int my_rank;

  printf("%s\n", argv[1]);
  sleep(5);
#if 1
  if (argc != 2) {
    printf("my_rank missing.\n");
    return EXIT_FAILURE;
  }
  my_rank = atoi(argv[1]);
  printf("my_rank = %d.\n", my_rank);

  filename = getenv("THE_HOSTS");
  if (filename == NULL) {
    printf("THE_HOSTS not set.\n");
    return EXIT_FAILURE;
  }

  hosts = parse_hosts(filename, &count);

  if (my_rank < 0 || my_rank >= count) {
    printf("my_rank not in range.\n");
    return EXIT_FAILURE;
  }

  run_test(hosts, count, my_rank);

  free(hosts);
#endif
  printf("[PASS]\n");
  fflush(stdout);
  return EXIT_SUCCESS;
}
#endif
